using System;
using System.Collections;
using Server.Multis;
using Server.Mobiles;
using Server.Network;

namespace Server.Items
{
	public class TreasureMessageChest : WoodenChest
	{
      public static Type[] Artifacts = new Type[]
		{
			typeof( CookedFish ), typeof( CookedFish2 ), 
			typeof( Knitting ), typeof( LanternPost ),
			typeof( MetalPitcher ), typeof( MouldingBoard ),
			typeof( PileOfGarbage ), typeof( PegBoard ),
			typeof( PlateOfFood1 ), typeof( PlateOfFood2 ),
			typeof( PlateOfFood3 ), typeof( PlateOfFood4 ),
			typeof( DirtyPlate ), typeof( RawFish ),
			typeof( RawFish2 ), typeof( FishHead ),
			typeof( FishHeads ), typeof( RoseInVase ),
			typeof( Silverware ), typeof( SlicedHam ), 
			typeof( SkullMug ), typeof( GreenBottle ), typeof( RedBottle ),
			typeof( SmallBrownBottle ), typeof( SmallGreenBottle ), typeof( SmallVioletBottle ),
			typeof( TinyYellowBottle ), typeof( SmallBlueFlask ), typeof( SmallYellowFlask ),
			typeof( SmallRedFlask ), typeof( SmallEmptyFlask ), typeof( YellowBeaker ),
			typeof( RedBeaker ), typeof( BlueBeaker ), typeof( GreenBeaker ),
			typeof( EmptyCurvedFlaskW ), typeof( RedCurvedFlask ), typeof( LtBlueCurvedFlask ),
			typeof( EmptyCurvedFlaskE ), typeof( BlueCurvedFlask ), typeof( GreenCurvedFlask ),
			typeof( RedRibbedFlask ), typeof( VioletRibbedFlask ), typeof( EmptyRibbedFlask ),
			typeof( LargeYellowFlask ), typeof( LargeVioletFlask ), typeof( LargeEmptyFlask ),
			typeof( SmallBlueBottle ), typeof( SmallGreenBottle2 ), typeof( EmptyJar ),
			typeof( FullJar ), typeof( HalfEmptyJar ), typeof( EmptyJars3 ),
			typeof( EmptyJars4 ), typeof( FullJars3 ), typeof( FullJars4 ),
			typeof( EmptyJars2 ), typeof( FullJars2 ), typeof( HalfEmptyJars2 ),
			typeof( EmptyVial ), typeof( HourglassAni ), typeof( TinyRedBottle ),
			typeof( PlayingCards ), typeof( PlayingCards2 ), typeof( PlayingCards3 ),
			typeof( PlayingCards4 ), typeof( PlayingCards5 ), typeof( ForgedMetal ),
			typeof( FruitBasket ), typeof( SlabOfBacon ), typeof( Beeswax ),
			typeof( IronWire ), typeof( SilverWire ), typeof( GoldWire ),
			typeof( CopperWire ), typeof( WhiteDriedFlowers ), typeof( GreenDriedFlowers ),
			typeof( DriedOnions ), typeof( DriedHerbs ), typeof( Whip ),
			typeof( PaintsAndBrush ), typeof( PenAndInk ), typeof( ChiselsNorth ),
			typeof( ChiselsWest ), typeof( DirtyPan ), typeof( DirtySmallRoundPot ),
			typeof( DirtyPot ), typeof( DirtyRoundPot ), typeof( DirtyFrypan ),
			typeof( DirtySmallPot ), typeof( DirtyKettle ), typeof( MagicCrystalBall )
		};
      
      [Constructable]
		public TreasureMessageChest( int low, int high ) : this( Utility.RandomMinMax( low < 15 ? 15 : low, high < low ? low : high ) )
		{
		}

		[Constructable]
		public TreasureMessageChest() : this( 1200, 2000 )
		{
		}

		[Constructable]
		public TreasureMessageChest( int amount ) : base()
		{
			Weight = 5.0;
			Name = "treasure chest";
			Hue = Utility.RandomNeutralHue();

			switch ( Utility.Random( 3 ) )  // modify as necessary
			{
				case 0: TrapType = TrapType.None; break;
				case 1: TrapType = TrapType.None; break;
				case 2: TrapType = TrapType.ExplosionTrap; break;
			}

			TrapPower = amount < 100 ? Utility.RandomMinMax( amount - 15, amount ) : 100;
					
			Locked = true;
			LockLevel = 50;
			MaxLockLevel = 50;

			DropItem( new Gold( amount ) );

			switch ( Utility.Random( 9 ))
			{
				case 0: DropItem( new StarSapphire(20) ); break;
				case 1: DropItem( new Emerald(20) ); break;
				case 2: DropItem( new Sapphire(20) ); break;
				case 3: DropItem( new Ruby(20) ); break;
				case 4: DropItem( new Citrine(20) ); break;
				case 5: DropItem( new Amethyst(20) ); break;
				case 6: DropItem( new Tourmaline(20) ); break;
				case 7: DropItem( new Amber(20) ); break;
				case 8: DropItem( new Diamond(20) ); break;
			}

			for ( int i = 0; i < 15; i++ )
			{
				Item item = Loot.RandomMLGem();
				DropItem( item );
			}

         DropItem( new Tokens( Utility.RandomMinMax( 10, 25 ) ) );
         DropItem( new SkillBall( 3.0 ) );
         DropItem( new CechovniMince( Utility.RandomList( 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 15, 15, 15, 15, 15, 15, 100 ) ) );
         
         if (Utility.RandomDouble() < 0.75)
         {
    			Item item = (Item)Activator.CreateInstance( Artifacts[Utility.Random(Artifacts.Length)] );
    			DropItem( item );
         }
		}

		public TreasureMessageChest( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

		}
	}
}